/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;

public class IETags {
    private static final Map<TagKey<Block>, TagKey<Item>> toItemTag = new HashMap<TagKey<Block>, TagKey<Item>>();
    private static final Map<EnumMetals, MetalTags> metals = new EnumMap<EnumMetals, MetalTags>(EnumMetals.class);
    public static final TagKey<Item> clay;
    public static final TagKey<Block> clayBlock;
    public static final TagKey<Item> charCoal;
    public static final TagKey<Block> glowstoneBlock;
    public static final TagKey<Block> colorlessSandstoneBlocks;
    public static final TagKey<Block> redSandstoneBlocks;
    public static final TagKey<Block> treatedWood;
    public static final TagKey<Block> treatedWoodSlab;
    public static final TagKey<Block> coalCokeBlock;
    public static final TagKey<Block> scaffoldingSteel;
    public static final TagKey<Block> scaffoldingAlu;
    public static final TagKey<Block> sheetmetals;
    public static final TagKey<Block> fencesSteel;
    public static final TagKey<Block> fencesAlu;
    public static final TagKey<Item> treatedStick;
    public static final TagKey<Item> ironRod;
    public static final TagKey<Item> steelRod;
    public static final TagKey<Item> metalRods;
    public static final TagKey<Item> aluminumRod;
    public static final TagKey<Item> fiberHemp;
    public static final TagKey<Item> fabricHemp;
    public static final TagKey<Item> coalCoke;
    public static final TagKey<Item> slag;
    public static final TagKey<Item> coalCokeDust;
    public static final TagKey<Item> hopGraphiteDust;
    public static final TagKey<Item> hopGraphiteIngot;
    public static final TagKey<Item> copperWire;
    public static final TagKey<Item> electrumWire;
    public static final TagKey<Item> aluminumWire;
    public static final TagKey<Item> steelWire;
    public static final TagKey<Item> leadWire;
    public static final TagKey<Item> allWires;
    public static final TagKey<Item> saltpeterDust;
    public static final TagKey<Item> sulfurDust;
    public static final TagKey<Item> sawdust;
    public static final TagKey<Item> plates;
    public static final TagKey<Item> plasticPlate;
    public static final TagKey<Item> sawblades;
    public static final TagKey<Item> forbiddenInCrates;
    public static final TagKey<Item> circuitPCB;
    public static final TagKey<Item> circuitLogic;
    public static final TagKey<Item> circuitSolder;
    public static final TagKey<Item> hammers;
    public static final TagKey<Item> screwdrivers;
    public static final TagKey<Item> wirecutters;
    public static final TagKey<Item> toolboxTools;
    public static final TagKey<Item> toolboxFood;
    public static final TagKey<Item> toolboxWiring;
    public static final TagKey<Item> connectorInsulator;
    public static final TagKey<Block> hammerHarvestable;
    public static final TagKey<Block> wirecutterHarvestable;
    public static final TagKey<Block> drillHarvestable;
    public static final TagKey<Item> tools;
    public static final TagKey<Item> pickaxes;
    public static final TagKey<Item> shovels;
    public static final TagKey<Item> axes;
    public static final TagKey<Item> hoes;
    public static final TagKey<Item> powerpackForbidAttach;
    public static final TagKey<Item> recyclingIgnoredComponents;
    public static final TagKey<Item> recyclingWhitelist;
    public static final TagKey<Item> recyclingBlacklist;
    public static final TagKey<Fluid> fluidCreosote;
    public static final TagKey<Fluid> fluidPlantoil;
    public static final TagKey<Fluid> fluidEthanol;
    public static final TagKey<Fluid> fluidBiodiesel;
    public static final TagKey<Fluid> fluidConcrete;
    public static final TagKey<Fluid> fluidHerbicide;
    public static final TagKey<Fluid> fluidRedstoneAcid;
    public static final TagKey<Fluid> fluidPotion;
    public static final TagKey<Fluid> fluidAcetaldehyde;
    public static final TagKey<Fluid> fluidResin;
    public static final TagKey<Fluid> drillFuel;
    public static final TagKey<EntityType<?>> shaderbagWhitelist;
    public static final TagKey<EntityType<?>> shaderbagBlacklist;

    public static TagKey<Item> getItemTag(TagKey<Block> blockTag) {
        Preconditions.checkArgument((boolean)toItemTag.containsKey(blockTag));
        return toItemTag.get(blockTag);
    }

    public static MetalTags getTagsFor(EnumMetals metal) {
        return metals.get((Object)metal);
    }

    private static TagKey<Block> createBlockTag(ResourceLocation name) {
        TagKey<Block> blockTag = TagUtils.createBlockWrapper(name);
        toItemTag.put(blockTag, TagUtils.createItemWrapper(name));
        return blockTag;
    }

    public static void forAllBlocktags(BiConsumer<TagKey<Block>, TagKey<Item>> out) {
        for (Map.Entry<TagKey<Block>, TagKey<Item>> entry : toItemTag.entrySet()) {
            out.accept(entry.getKey(), entry.getValue());
        }
    }

    private static ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    public static ResourceLocation getOre(String type) {
        return IETags.forgeLoc("ores/" + type);
    }

    public static ResourceLocation getRawOre(String type) {
        return IETags.forgeLoc("raw_materials/" + type);
    }

    public static ResourceLocation getNugget(String type) {
        return IETags.forgeLoc("nuggets/" + type);
    }

    public static ResourceLocation getIngot(String type) {
        return IETags.forgeLoc("ingots/" + type);
    }

    public static ResourceLocation getGem(String type) {
        return IETags.forgeLoc("gems/" + type);
    }

    public static ResourceLocation getStorageBlock(String type) {
        return IETags.forgeLoc("storage_blocks/" + type);
    }

    public static ResourceLocation getRawBlock(String type) {
        return IETags.getStorageBlock("raw_" + type);
    }

    public static ResourceLocation getDust(String type) {
        return IETags.forgeLoc("dusts/" + type);
    }

    public static ResourceLocation getPlate(String type) {
        return IETags.forgeLoc("plates/" + type);
    }

    public static ResourceLocation getRod(String type) {
        return IETags.forgeLoc("rods/" + type);
    }

    public static ResourceLocation getGear(String type) {
        return IETags.forgeLoc("gears/" + type);
    }

    public static ResourceLocation getWire(String type) {
        return IETags.forgeLoc("wires/" + type);
    }

    public static ResourceLocation getSheetmetalBlock(String type) {
        return IETags.forgeLoc("sheetmetals/" + type);
    }

    private static ResourceLocation rl(String path) {
        return new ResourceLocation("immersiveengineering", path);
    }

    static {
        toItemTag.put((TagKey<Block>)Tags.Blocks.STORAGE_BLOCKS, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS);
        toItemTag.put((TagKey<Block>)Tags.Blocks.ORES, (TagKey<Item>)Tags.Items.ORES);
        toItemTag.put((TagKey<Block>)Tags.Blocks.ORES_IN_GROUND_STONE, (TagKey<Item>)Tags.Items.ORES_IN_GROUND_STONE);
        toItemTag.put((TagKey<Block>)Tags.Blocks.ORES_IN_GROUND_DEEPSLATE, (TagKey<Item>)Tags.Items.ORES_IN_GROUND_DEEPSLATE);
        toItemTag.put((TagKey<Block>)Tags.Blocks.ORE_RATES_SINGULAR, (TagKey<Item>)Tags.Items.ORE_RATES_SINGULAR);
        toItemTag.put((TagKey<Block>)BlockTags.f_13090_, (TagKey<Item>)ItemTags.f_13168_);
        clay = TagUtils.createItemWrapper(IETags.forgeLoc("clay"));
        clayBlock = IETags.createBlockTag(IETags.getStorageBlock("clay"));
        charCoal = TagUtils.createItemWrapper(IETags.forgeLoc("charcoal"));
        glowstoneBlock = IETags.createBlockTag(IETags.getStorageBlock("glowstone"));
        colorlessSandstoneBlocks = IETags.createBlockTag(IETags.forgeLoc("sandstone/colorless"));
        redSandstoneBlocks = IETags.createBlockTag(IETags.forgeLoc("sandstone/red"));
        treatedWood = IETags.createBlockTag(IETags.forgeLoc("treated_wood"));
        treatedWoodSlab = IETags.createBlockTag(IETags.forgeLoc("treated_wood_slab"));
        coalCokeBlock = IETags.createBlockTag(IETags.getStorageBlock("coal_coke"));
        scaffoldingSteel = IETags.createBlockTag(IETags.rl("scaffoldings/steel"));
        scaffoldingAlu = IETags.createBlockTag(IETags.rl("scaffoldings/aluminum"));
        sheetmetals = IETags.createBlockTag(IETags.forgeLoc("sheetmetals"));
        fencesSteel = IETags.createBlockTag(IETags.forgeLoc("fences/steel"));
        fencesAlu = IETags.createBlockTag(IETags.forgeLoc("fences/aluminum"));
        treatedStick = TagUtils.createItemWrapper(IETags.getRod("treated_wood"));
        ironRod = TagUtils.createItemWrapper(IETags.getRod("iron"));
        steelRod = TagUtils.createItemWrapper(IETags.getRod("steel"));
        metalRods = TagUtils.createItemWrapper(IETags.getRod("all_metal"));
        aluminumRod = TagUtils.createItemWrapper(IETags.getRod("aluminum"));
        fiberHemp = TagUtils.createItemWrapper(IETags.forgeLoc("fiber_hemp"));
        fabricHemp = TagUtils.createItemWrapper(IETags.forgeLoc("fabric_hemp"));
        coalCoke = TagUtils.createItemWrapper(IETags.forgeLoc("coal_coke"));
        slag = TagUtils.createItemWrapper(IETags.forgeLoc("slag"));
        coalCokeDust = TagUtils.createItemWrapper(IETags.getDust("coal_coke"));
        hopGraphiteDust = TagUtils.createItemWrapper(IETags.getDust("hop_graphite"));
        hopGraphiteIngot = TagUtils.createItemWrapper(IETags.getIngot("hop_graphite"));
        copperWire = TagUtils.createItemWrapper(IETags.getWire("copper"));
        electrumWire = TagUtils.createItemWrapper(IETags.getWire("electrum"));
        aluminumWire = TagUtils.createItemWrapper(IETags.getWire("aluminum"));
        steelWire = TagUtils.createItemWrapper(IETags.getWire("steel"));
        leadWire = TagUtils.createItemWrapper(IETags.getWire("lead"));
        allWires = TagUtils.createItemWrapper(IETags.forgeLoc("wires"));
        saltpeterDust = TagUtils.createItemWrapper(IETags.getDust("saltpeter"));
        sulfurDust = TagUtils.createItemWrapper(IETags.getDust("sulfur"));
        sawdust = TagUtils.createItemWrapper(IETags.getDust("wood"));
        plates = TagUtils.createItemWrapper(IETags.forgeLoc("plates"));
        plasticPlate = TagUtils.createItemWrapper(IETags.getPlate("plastic"));
        sawblades = TagUtils.createItemWrapper(IETags.forgeLoc("sawblades"));
        forbiddenInCrates = TagUtils.createItemWrapper(IETags.rl("forbidden_in_crates"));
        circuitPCB = TagUtils.createItemWrapper(IETags.rl("circuits/pcb"));
        circuitLogic = TagUtils.createItemWrapper(IETags.rl("circuits/logic"));
        circuitSolder = TagUtils.createItemWrapper(IETags.rl("circuits/solder"));
        hammers = TagUtils.createItemWrapper(IETags.rl("tools/hammers"));
        screwdrivers = TagUtils.createItemWrapper(IETags.rl("tools/screwdrivers"));
        wirecutters = TagUtils.createItemWrapper(IETags.rl("tools/wirecutters"));
        toolboxTools = TagUtils.createItemWrapper(IETags.rl("toolbox/tools"));
        toolboxFood = TagUtils.createItemWrapper(IETags.rl("toolbox/food"));
        toolboxWiring = TagUtils.createItemWrapper(IETags.rl("toolbox/wiring"));
        connectorInsulator = TagUtils.createItemWrapper(IETags.rl("connector_insulator"));
        hammerHarvestable = TagUtils.createBlockWrapper(IETags.rl("mineable/hammer"));
        wirecutterHarvestable = TagUtils.createBlockWrapper(IETags.rl("mineable/wirecutter"));
        drillHarvestable = TagUtils.createBlockWrapper(IETags.rl("mineable/drill"));
        tools = TagUtils.createItemWrapper(IETags.forgeLoc("tools"));
        pickaxes = TagUtils.createItemWrapper(IETags.forgeLoc("tools/pickaxes"));
        shovels = TagUtils.createItemWrapper(IETags.forgeLoc("tools/shovels"));
        axes = TagUtils.createItemWrapper(IETags.forgeLoc("tools/axes"));
        hoes = TagUtils.createItemWrapper(IETags.forgeLoc("tools/hoes"));
        powerpackForbidAttach = TagUtils.createItemWrapper(IETags.rl("powerpack/forbid_attach"));
        recyclingIgnoredComponents = TagUtils.createItemWrapper(IETags.rl("recycling/ignored_components"));
        recyclingWhitelist = TagUtils.createItemWrapper(IETags.rl("recycling/whitelist"));
        recyclingBlacklist = TagUtils.createItemWrapper(IETags.rl("recycling/blacklist"));
        fluidCreosote = TagUtils.createFluidWrapper(IETags.forgeLoc("creosote"));
        fluidPlantoil = TagUtils.createFluidWrapper(IETags.forgeLoc("plantoil"));
        fluidEthanol = TagUtils.createFluidWrapper(IETags.forgeLoc("ethanol"));
        fluidBiodiesel = TagUtils.createFluidWrapper(IETags.forgeLoc("biodiesel"));
        fluidConcrete = TagUtils.createFluidWrapper(IETags.forgeLoc("concrete"));
        fluidHerbicide = TagUtils.createFluidWrapper(IETags.forgeLoc("herbicide"));
        fluidRedstoneAcid = TagUtils.createFluidWrapper(IETags.forgeLoc("redstone_acid"));
        fluidPotion = TagUtils.createFluidWrapper(IETags.forgeLoc("potion"));
        fluidAcetaldehyde = TagUtils.createFluidWrapper(IETags.forgeLoc("acetaldehyde"));
        fluidResin = TagUtils.createFluidWrapper(IETags.forgeLoc("phenolic_resin"));
        drillFuel = TagUtils.createFluidWrapper(IETags.rl("drill_fuel"));
        shaderbagWhitelist = TagUtils.createEntityWrapper(IETags.rl("shaderbag/whitelist"));
        shaderbagBlacklist = TagUtils.createEntityWrapper(IETags.rl("shaderbag/blacklist"));
        for (EnumMetals m : EnumMetals.values()) {
            metals.put(m, new MetalTags(m));
        }
    }

    public static class MetalTags {
        public final TagKey<Item> ingot;
        public final TagKey<Item> nugget;
        @Nullable
        public final TagKey<Item> rawOre;
        public final TagKey<Item> plate;
        public final TagKey<Item> dust;
        public final TagKey<Block> storage;
        public final TagKey<Block> sheetmetal;
        @Nullable
        public final TagKey<Block> ore;
        @Nullable
        public final TagKey<Block> rawBlock;

        private MetalTags(EnumMetals m) {
            String name = m.tagName();
            TagKey ore = null;
            TagKey<Item> rawOre = null;
            TagKey rawBlock = null;
            if (m.shouldAddOre()) {
                ore = IETags.createBlockTag(IETags.getOre(name));
                rawOre = TagUtils.createItemWrapper(IETags.getRawOre(name));
                rawBlock = IETags.createBlockTag(IETags.getRawBlock(name));
            }
            if (!m.isVanillaMetal()) {
                this.storage = IETags.createBlockTag(IETags.getStorageBlock(name));
            } else if (m == EnumMetals.COPPER) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_COPPER;
                ore = Tags.Blocks.ORES_COPPER;
                rawBlock = Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER;
            } else if (m == EnumMetals.IRON) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_IRON;
                ore = Tags.Blocks.ORES_IRON;
                rawBlock = Tags.Blocks.STORAGE_BLOCKS_RAW_IRON;
            } else if (m == EnumMetals.GOLD) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_GOLD;
                ore = Tags.Blocks.ORES_GOLD;
                rawBlock = Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD;
            } else {
                throw new RuntimeException("Unkown vanilla metal: " + m.name());
            }
            this.sheetmetal = IETags.createBlockTag(IETags.getSheetmetalBlock(name));
            this.nugget = TagUtils.createItemWrapper(IETags.getNugget(name));
            this.ingot = TagUtils.createItemWrapper(IETags.getIngot(name));
            this.plate = TagUtils.createItemWrapper(IETags.getPlate(name));
            this.dust = TagUtils.createItemWrapper(IETags.getDust(name));
            this.ore = ore;
            this.rawOre = rawOre;
            this.rawBlock = rawBlock;
        }
    }
}

